<?php

namespace App\Http\Controllers;

use App\Models\ClientEventTicket;
use App\Models\Event;
use App\Models\EventPayment;
use App\Models\EventTicket;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class EventController extends Controller
{
    //

    public function __construct()
    {
        $this->middleware('auth:api', ['except'=>['store_client_event_ticket', 'update_client_event_ticket', 
        'update_client_event_ticket_only_trx_id', 'store_event_payment', 'update_event_payment', 'all_events',
        'single_event'

        ] 
    
    ]);
    }


    public function single_event($event_id){
       // $userid = Auth()->user()->id;
        $event = Event::find($event_id);

        return response()->json(['status' => 'success', 
        'data' => ['event'=>$event, 'ticket' => $event->event_ticket, 'client_ticket' => $event->client_ticket, 'event_payment' =>$event->event_payment] 
    ],200);

    }



    public function all_events(){
        // $userid = Auth()->user()->id;
         $event = Event::all();
 
         return response()->json(['status' => 'success', 
         'data' => ['data'=>$event] 
     ],200);
 
     }

    // Create Event

    public function store_event(Request $request){

        $validator = Validator::make($request->all(), [
            'event_title' => 'required|string',
            'banner_image' => 'required|image|mimes:jpg,jpeg,png,gif,svg|max:4096',
            'description' => 'required|string',
            'venue' => 'required|string',
            'date' => 'required|string',
            'time' => 'required|string',
            'contact_no' => 'required|string',
            'whatsapp_no' => 'required|string',
            
        ],
        [
            'event_title' => 'Title is required',
            
            'description' => 'Description is required',
            'venue' => 'Venue is required',
            'date' => 'Date is required',
            'time' => 'Time is required',
            'contact_no' => 'Contact is required',
            'whatsapp_no' => 'WhatsApp number is required',
            
            'banner_image.required' => 'Kindly upload an image for the event',
            'banner_image.image' => 'The file must be an image',
            'banner_image.mimes' => 'Allowed image extensions jpg,jpeg,png,gif,svg',
            'banner_image.max' => 'max size for images is 4MB'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new Event();

        if($request->has('banner_image')){

            
            $image = $request->file('banner_image');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();

            $image->move('uploads/events',$filename);

            $full_path = 'public/uploads/events/'.$filename;

            $whatsapp_no = $request->whatsapp_no;
            if(str_starts_with($whatsapp_no, '0')){

                $no = ltrim($whatsapp_no, '0');

                $whatsapp_no = 'https://wa.me/233'.$no;

            }

            $details->event_title = $request->event_title;
            $details->banner_image = $full_path;
            $details->description = $request->description;
            $details->venue =  $request->venue;
            $details->date = $request->date;
            $details->time =  $request->time;
            $details->contact_no = $request->contact_no;
            

            $details->whatsapp_no =  $whatsapp_no;
            $details->user_id = Auth()->user()->id;
    
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Event added successfully'],200);

        }
        
    }


    // Update Event

    public function update_event(Request $request){

        $validator = Validator::make($request->all(), [
            'event_title' => 'required|string',
            
            'description' => 'required|string',
            'venue' => 'required|string',
            'date' => 'required|string',
            'time' => 'required|string',
            'contact_no' => 'required|string',
            'whatsapp_no' => 'required|string',
            
        ],
        [
            'event_title' => 'Title is required',
            
            'description' => 'Description is required',
            'venue' => 'Venue is required',
            'date' => 'Date is required',
            'time' => 'Time is required',
            'contact_no' => 'Contact is required',
            'whatsapp_no' => 'WhatsApp number is required'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = Event::find($request->event_id);

        if($request->has('banner_image')){

            
            $image = $request->file('banner_image');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();

            $image->move('uploads/events',$filename);

            $full_path = 'public/uploads/events/'.$filename;

            $whatsapp_no = $request->whatsapp_no;
            if(str_starts_with($whatsapp_no, '0')){

                $no = ltrim($whatsapp_no, '0');

                $whatsapp_no = 'https://wa.me/233'.$no;

            }

            $details->event_title = $request->event_title;
            $details->banner_image = $full_path;
            $details->description = $request->description;
            $details->venue =  $request->venue;
            $details->date = $request->date;
            $details->time =  $request->time;
            $details->contact_no = $request->contact_no;
            $details->whatsapp_no =  $whatsapp_no;
            
    
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Event updated successfully'],200);

        }
        else{

            $details->event_title = $request->event_title;
            
            $details->description = $request->description;
            $details->venue =  $request->venue;
            $details->date = $request->date;
            $details->time =  $request->time;
            $details->contact_no = $request->contact_no;
            $details->whatsapp_no =  $request->whatsapp_no;
            
    
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Event updated successfully'],200);

        }
        
    }


     // Create Event Ticket

     public function store_event_ticket(Request $request){

        $validator = Validator::make($request->all(), [
            'ticket_title' => 'required|string',
            'paid' => 'required|string',
            'ticket_price' => 'required|string',
            'event_id' => 'required|string'
        ],
        [
            'ticket_title' => 'Title is required',
            'paid' => 'Paid is required, ',
            'ticket_price' => 'Price is required',
            'event_id' => 'Event ID is required'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new EventTicket();


            $details->ticket_title = $request->ticket_title;
        
            $details->paid = $request->paid;
        
            $details->ticket_price = $request->ticket_price;
            $details->event_id =  $request->event_id;
            
    
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Event Ticket added successfully'],200);

        
        
    }


    // Update Event Ticket

    public function update_event_ticket(Request $request){

        $validator = Validator::make($request->all(), [
            'ticket_title' => 'required|string',
            'paid' => 'required|string',
            'ticket_price' => 'required|string',
            
        ],
        [
            'ticket_title' => 'Title is required',
            'paid' => 'Paid is required',
            'ticket_price' => 'Price is required',
            
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = EventTicket::find($request->event_ticket_id);


            $details->ticket_title = $request->ticket_title;
        
            $details->paid = $request->paid;
        
            $details->ticket_price = $request->ticket_price;
            
            
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Event Ticket updated successfully'],200);
        
    }



    // Create Client Event Ticket

    public function store_client_event_ticket($ticket_title,
    $ticket_price,
    $event_id,
    $event_ticket_id,
    $client_email,
    $client_mobile,
    $client_name,
    $transaction_id){

        // $validator = Validator::make($request->all(), [
        //     'ticket_title' => 'required|string',
        //     'event_ticket_id' => 'required|string',
        //     'ticket_price' => 'required|string',
        //     'client_name' => 'required|string',
        //     'client_email' => 'required|string',
        //     'client_mobile' => 'required|string',
            
        //     'event_id' => 'required|string'
        // ],
        // [
        //     'ticket_title' => 'Title is required',
        //     'event_ticket_id' => 'ticket id is required',
            
        //     'ticket_price' => 'Price is required',
        //     'client_name' => 'Name is required',
        //     'client_email' => 'Email is required',
        //     'client_mobile' => 'Mobile is required',
        //     'event_id' => 'Event ID is required'
    
        // ]
        // );

        // if($validator->fails()){
        //     return response()->json(  ['status' => 'error',
        //         'message' => $validator->errors()], 400);
        // }

        $details = new ClientEventTicket();


            $details->ticket_title = $ticket_title;
        
            $details->event_ticket_id = $event_ticket_id;

            $details->ticket_price =  $ticket_price;
        
            $details->ticket_token = Str::random(16);

            $details->event_id =  $event_id;

            $details->client_name =  $client_name;

            $details->client_email =  $client_email;

            $details->client_mobile =  $client_mobile;

            $details->transaction_id = $transaction_id;

            $details->save();

            return 'success';
    
            //return response()->json(['status' => 'success','message' => 'Client Event Ticket added successfully'],200);

        
        
    }


    // Update Client Event Ticket

    public function update_client_event_ticket(Request $request){

        $validator = Validator::make($request->all(), [
        
            'client_event_ticket_id' => 'required|string',
            
            'transaction_id' => 'required|string'
        ],
        [
            'client_event_ticket_id' => 'client_event_ticket_id is required',
            
            'transaction_id' => 'transaction_id is required'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = ClientEventTicket::where([
            ['id','=', $request->client_event_ticket_id],
            ['transaction_id', '=', $request->transaction_id]

            ])->first();

        
            $details->ticket_token = Str::random(16);

         
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Client Event Ticket updated successfully'],200);
        
    }



    // Update Client Event Ticket

    public function update_client_event_ticket_only_trx_id(Request $request){

        $validator = Validator::make($request->all(), [
        
            
            'transaction_id' => 'required|string'
        ],
        [
          
            'transaction_id' => 'transaction_id is required'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = ClientEventTicket::where('transaction_id',$request->transaction_id)->first();

        
            $details->ticket_token = Str::random(16);

         
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Client Event Ticket updated successfully'],200);
        
    }





     // Create Event Payment

     public function store_event_payment(Request $request){

        $validator = Validator::make($request->all(), [
            'ticket_title' => 'required|string',
            'event_ticket_id' => 'required|string',
            'amount' => 'required|string',
            'client_name' => 'required|string',
            'client_email' => 'required|string',
            'client_mobile' => 'required|string',
        ],
        [
            'ticket_title.required' => 'Title is required',
            'event_ticket_id.required' => 'ticket id is required',
            
            'amount.required' => 'Price is required',
            'client_name.required' => 'Name is required',
            'client_email.required' => 'Email is required',
            'client_mobile.required' => 'Mobile is required',
            
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

     

        $details = new EventPayment();

        //  $qty = $request->qty;

            $details->user_id = $request->user_id;

            $details->event_id = $request->event_id;


            $details->ticket_title = $request->ticket_title;
        
            $details->event_ticket_id = $request->event_ticket_id;

            $details->amount =  $request->amount;

            $details->qty = $request->qty;

            $details->transaction_id = $request->transaction_id;
        

            $details->client_name =  $request->client_name;

            $details->client_email =  $request->client_email;

            $details->client_mobile =  $request->client_mobile;

          

            $details->save();

              //$this-> store_client_event_ticket($request);

              
        
             
              $charge = ($request->amount + ($request->amount * 0.02)) * 100 ;
            //  $description = 'Payment for event tickets '.$request->ticket_title;
             
             
              $url = "https://api.paystack.co/transaction/initialize";
             
             
             $fields = [
              'email' => $request->client_email,
              'amount' => $charge,
              'reference' =>$request->transaction_id,
              'callback_url' => "http://127.0.0.1:8000/api/event/payment-update",
             ];
             $fields_string = http_build_query($fields);
             //open connection
             $ch = curl_init();
            
             curl_setopt($ch,CURLOPT_URL, $url);
             curl_setopt($ch,CURLOPT_POST, true);
             curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
             curl_setopt($ch, CURLOPT_HTTPHEADER, array(
              "Authorization: Bearer sk_test_02c3573c4651c90aa587c5b39235207ae97de8bb",
              "Cache-Control: no-cache",
             ));
             
             //So that curl_exec returns the contents of the cURL; rather than echoing it
             curl_setopt($ch,CURLOPT_RETURNTRANSFER, true); 
             
             //execute post
             $result = curl_exec($ch);
             $res = json_decode($result,true);
             $domain = $res["data"]["authorization_url"]; 
             

            return response()->json(['status' => 'success','payment_url' => $domain],200);

        
        
    }


    // Update Event Payment

    public function update_event_payment(Request $request){

        // $validator = Validator::make($request->all(), [
        //     'transaction_id' => 'required|string',
          
        // ],
        // [
        //     'transaction_id' => 'Transaction ID is required',
         
        // ]
        // );

        // if($validator->fails()){
        //     return response()->json(  ['status' => 'error',
        //         'message' => $validator->errors()], 400);
        // }

          
        
        
     /*  This Logic is for verifying top ups via web  */
     
        $transaction_id = $request->query('trxref'); 



        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/$transaction_id",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer sk_test_02c3573c4651c90aa587c5b39235207ae97de8bb",
            "Cache-Control: no-cache",
            ),
        ));
        
        $response = curl_exec($curl);
       // dd($response);
        $err = curl_error($curl);
        curl_close($curl);
        
        if ($err) {
            return response()->json(['status' => 'error','message' => "cURL Error #:" . $err],401);
            
        }

        else 
        {  
            $res = json_decode($response,true);
            $paymentStatus = $res["data"]["status"];
            $isLive = $res["data"]["domain"];
            
            

            if($paymentStatus == "success")
            {
                $paymentAmount = $res["data"]["amount"];
                
                $amount_paid = ($paymentAmount/100) ;

                $paid_status = "PAID";

                $details = EventPayment::where('transaction_id',$transaction_id)->first();
                    
            
                if($details->payment_status == 'PAID'){
                    return response()->json(['status' => 'error','message' => 'Not Allowed'],401);
                }

                if($details->amount > $amount_paid){
                    return response()->json(['status' => 'error','message' => 'Amount not paid in full'],401);
                }
                else{

                    $details->amount_paid =  $amount_paid;

                    $details->payment_status =  $paid_status;

                    
                    $details->save();


                    $ticket_price =  $details->amount/$details->qty;
                    $ticket_title =  $details->ticket_title;
            
                    $event_ticket_id = $details->event_ticket_id;

                    $event_id = $details->event_id;

                    $client_name = $details->client_name;

                    $client_email = $details->client_email;

                    $client_mobile = $details->client_mobile;

                    $transaction_id = $details->transaction_id;

                    for ($i = 0; $i< $details->qty; $i++){
                    
                        $this-> store_client_event_ticket(
                        $ticket_title,
                        $ticket_price,
                        $event_id,
                        $event_ticket_id,
                        $client_email,
                        $client_mobile,
                        $client_name,
                        $transaction_id);

                    }

                
            
                    return response()->json(['status' => 'success','message' => 'Your payment was successful'],200);
                }
            }
        
        }
        
    }


    public function delete_event($event_id){
        $del = Event::find($event_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function delete_event_ticket($event_ticket_id){
        $del = EventTicket::find($event_ticket_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function delete_client_ticket($client_ticket_id){
        $del = ClientEventTicket::find($client_ticket_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function delete_event_payment($event_payment_id){
        $del = EventPayment::find($event_payment_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }

}
