<?php

namespace App\Http\Controllers;

use App\Models\Bank_Wallet;
use App\Models\Business_Profile;
use App\Models\User;
use App\Models\Contact_Details;
use App\Models\Identification;
use App\Models\Momo_Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class UserController extends Controller
{
    // 

    public function __construct()
    {
        $this->middleware('auth:api', ['except'=>['fetch_banks', 'fetch_momo_wallets', 'do_kyc', 'test_query'] ]);
    }


    public function user_index(){
        $userid = Auth()->user()->id;
        $user = User::find($userid);

        return response()->json(['status' => 'success', 'data' => ['contact'=>$user->contact_details, 'business'=>$user->business_profile ,'identification'=>$user->identification ,'momo'=>$user->momo_wallet, 'bank'=>$user->bank_wallet] ],200);

    }

    // For fetching the list of banks
    public function fetch_banks(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank?currency=GHS",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer ",
            "Cache-Control: no-cache",
            ),
        ));

        $data = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            //echo "cURL Error #:" . $err;
            return response()->json(  ['status' => 'error',
                'message' => $err], 400);
        } else {
            $final_data = json_decode($data);
            return response()->json(['status' => 'success', 'data' => $final_data->data],200);
        }

        

    }


    // For fetching the list of momo networks
    public function fetch_momo_wallets(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank?currency=GHS&type=mobile_money",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer ",
            "Cache-Control: no-cache",
            ),
        ));

        $data = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            //echo "cURL Error #:" . $err;
            return response()->json(  ['status' => 'error',
                'message' => $err], 400);
        } else {
            $final_data = json_decode($data);
            return response()->json(['status' => 'success', 'data' => $final_data->data],200);
        }

    }


    public function do_kyc(Request $request){

        //pk_test_bed0d0b578c7e378d855a8056792a05a689e90ee
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank/resolve?account_number=".$request->account_no."&bank_code=".$request->bank_code."",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer sk_test_02c3573c4651c90aa587c5b39235207ae97de8bb",
            "Cache-Control: no-cache",
            ),
        ));
        
        $data = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            return response()->json(  ['status' => 'error',
                'message' => $err], 400);
        } else {
            $final_data = json_decode($data);
           //return $final_data->data->account_name ;
            return response()->json(['status' => 'success', 'data' => $final_data->data->account_name],200);
        }
    }


    // Contact Related Code

    public function store_contact_details(Request $request){

        $validator = Validator::make($request->all(), [
            'digital_address' => 'required|string',
            'region' => 'required|string',
            'city' => 'required|string',
            'street' => 'required|string',
            'email' => 'required|string|email|unique:contact__details',
            'phone' => 'required|string|unique:contact__details',
            
        ],
        [
            'digital_address.required' => 'Kindly enter digital address',
            'region.required' => 'Kindly enter region',
            'city.required' => 'Kindly enter city',
            'street.required' => 'Kindly enter street',
            'email.required' => 'Kindly enter email',
            'email.unique' => 'Email already exist',
            'phone.required' => 'Kindly enter phone number',
            'phone.unique' => 'Phone already exist',
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new Contact_Details();

        $details->email = $request->email;
        $details->phone = $request->phone;
        $details->digital_addr = $request->digital_address;
       // $details->addr_country = '';
       $details->addr_region = $request->region;
        $details->addr_city = $request->city;
        $details->addr_street = $request->street;
        $details->user_id = Auth()->user()->id;

        $details->save();

        return response()->json(['status' => 'success','message' => 'Details added successfully'],200);
        
    }



    public function update_contact_details(Request $request){

        $validator = Validator::make($request->all(), [
            'digital_address' => 'required|string',
            'region' => 'required|string',
            'city' => 'required|string',
            'street' => 'required|string',
            'email' => 'required|string|email',
            'phone' => 'required|string',
            
        ],
        [
            'digital_address.required' => 'Kindly enter digital address',
            'region.required' => 'Kindly enter region',
            'city.required' => 'Kindly enter city',
            'street.required' => 'Kindly enter street',
            'email.required' => 'Kindly enter email',
            'phone.required' => 'Kindly enter phone number'
        
    
        ]
        );


        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }
        
       $details = Contact_Details::find($request->contact_id);

        $details->email = $request->email;
        $details->phone = $request->phone;
        $details->digital_addr = $request->digital_address;
       // $details->addr_country = '';
       $details->addr_region = $request->region;
        $details->addr_city = $request->city;
        $details->addr_street = $request->street;

        $details->save();

        return response()->json(['status' => 'success', 'message' => 'Details updated successfully'],200);

    }


    // Business Profile Related Code

    public function store_business_profile(Request $request){

        $validator = Validator::make($request->all(), [
            'business_name' => 'required|string',
            'description' => 'required|string'  
        ],
        [
            'business_name.required' => 'Kindly enter your business name',
            'description.required' => 'Kindly provide business description'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $biz = new Business_Profile();

        if($request->has('logo')){

            $image = $request->file('logo');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();



            $image->move('uploads/business/',$filename);

            $full_path = 'public/uploads/business/'.$filename;

            $biz->name = $request->business_name;

            $biz->description = $request->description;

            $biz->flyer = $full_path;

            $biz->user_id = Auth()->user()->id;
    
            $biz->save();

            return response()->json(['status' => 'success','message' => 'Business Profile added successfully'],200);

        }

        else{

            $biz->name = $request->business_name;

            $biz->description = $request->description;
           
            $biz->user_id = Auth()->user()->id;
    
            $biz->save();
    
            return response()->json(['status' => 'success','message' => 'Business Profile added successfully'],200);

        }

       
        
    }


    public function update_business_profile(Request $request){

        $validator = Validator::make($request->all(), [
            'business_name' => 'required|string',
            'description' => 'required|string'  
        ],
        [
            'business_name.required' => 'Kindly enter your business name',
            'description.required' => 'Kindly provide business description'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

       

        if($request->has('logo')){

            

            $image = $request->file('logo');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();

            

            $image->move('uploads/business/',$filename);

            $full_path = 'public/uploads/business/'.$filename;

          $biz =  Business_Profile::find($request->biz_id);

            $biz->name = $request->business_name;

            $biz->description = $request->description;

            $biz->flyer = $full_path;

            $biz->save();

            return response()->json(['status' => 'success','message' => 'Business Profile update successfully'],200);

        }

        else{

            $biz =  Business_Profile::find($request->biz_id);

            $biz->name = $request->business_name;

            $biz->description = $request->description;

            $biz->flyer = $request->logo_link;

            $biz->save();

            return response()->json(['status' => 'success','message' => 'Business Profile updated successfully'],200);

        }
        
    }


     // Identification Related Code

     public function store_identification(Request $request){

        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'id_type' => 'required|string',
            'id_no' => 'required|string|unique:identifications',
            'id_front' => 'required|image|mimes:jpg,jpeg,png,gif,svg|max:4096',
            
        ],
        [
            'first_name.required' => 'Kindly enter firstname',
            'last_name.required' => 'Kindly enter lastname',
            'id_type.required' => 'Kindly choose ID type',
            'id_no.required' => 'Kindly enter ID number',
            'id_no.unique' => 'ID number already exist',
            'id_front.required' => 'Kindly upload front side  image of ID',
            'id_front.image' => 'The file must be an image',
            'id_front.mimes' => 'Allowed image extensions jpg,jpeg,png,gif,svg',
            'id_front.max' => 'max size for images is 4MB'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new Identification();


        if($request->has('id_front')){

            
            $image = $request->file('id_front');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();

            $image->move('uploads/identity',$filename);

            $full_path = 'public/uploads/identity/'.$filename;

            $details->first_name = $request->first_name;
            $details->last_name = $request->last_name;
            $details->id_type = $request->id_type;
            $details->id_no = $request->id_no;
            $details->id_front = $full_path;
            $details->verified_status = 'UNVERIFIED';
            $details->user_id = Auth()->user()->id;
    
            $details->save();
    
            return response()->json(['status' => 'success','message' => 'Identity added successfully'],200);

        }

       
        
    }


    public function update_identification(Request $request){

        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'id_type' => 'required|string',
            'id_no' => 'required|string',
            'id_front' => 'required|image|mimes:jpg,jpeg,png,gif,svg|max:4096',
        ],
        [
            'first_name.required' => 'Kindly enter firstname',
            'last_name.required' => 'Kindly enter lastname',
            'id_type.required' => 'Kindly choose ID type',
            'id_no.required' => 'Kindly enter ID number',
            'id_front.required' => 'Kindly upload front side  image of ID',
            'id_front.image' => 'The file must be an image',
            'id_front.mimes' => 'Allowed image extensions jpg,jpeg,png,gif,svg',
            'id_front.max' => 'max size for images is 4MB'
    
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }


        if($request->has('id_front')){

            
            $image = $request->file('id_front');

            $filename = Str::random(32).".".$image->getClientOriginalExtension();

            $image->move('uploads/identity',$filename);

            $full_path = 'public/uploads/identity/'.$filename;

           $details = Identification::find($request->identity_id);
           $details->first_name = $request->first_name;
           $details->last_name = $request->last_name;
           $details->id_type = $request->id_type;
           $details->id_no = $request->id_no;
           $details->id_front = $full_path;
           $details->verified_status = 'UNVERIFIED';

           $details->save();
    
            return response()->json(['status' => 'success','message' => 'Identity updated successfully'],200);

        }
        

    }


    // Bank Wallet Related Code
    public function store_bank_wallet(Request $request){

        $validator = Validator::make($request->all(), [
            'bank_name' => 'required|string',
            'beneficiary_name' => 'required|string',
            'branch' => 'required|string',
            'bank_code' => 'required|string',
            'account_no' => 'required|string|unique:bank__wallets',
            
            
        ],
        [
            'bank_name.required' => 'Kindly choose a bank',
            'beneficiary_name.required' => 'Kindly enter name on the account',
            'branch.required' => 'Kindly enter the branch of the account',
            'bank_code.required' => 'Kindly set bank code',
            'account_no.required' => 'Kindly enter the account number',
            'account_no.unique' => 'Account already exist'
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new Bank_Wallet();

        $details->bank_name = $request->bank_name;
        $details->beneficiary_name = $request->beneficiary_name;
        $details->account_no = $request->account_no;
       $details->branch = $request->branch;
        $details->bank_code = $request->bank_code;
        $details->verified_status = 'UNVERIFIED';
        $details->user_id = Auth()->user()->id;

        $details->save();

        return response()->json(['status' => 'success','message' => 'Bank added successfully'],200);
        
    }



    public function update_bank_wallet(Request $request){

        $validator = Validator::make($request->all(), [
            'bank_name' => 'required|string',
            'beneficiary_name' => 'required|string',
            'branch' => 'required|string',
            'bank_code' => 'required|string',
            'account_no' => 'required|string',
            
            
        ],
        [
            'bank_name.required' => 'Kindly choose a bank',
            'beneficiary_name.required' => 'Kindly enter name on the account',
            'branch.required' => 'Kindly enter the branch of the account',
            'bank_code.required' => 'Kindly set bank code',
            'account_no.required' => 'Kindly enter the account number',
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }
        
       $details = Bank_Wallet::find($request->bank_wallet_id);

        $details->bank_name = $request->bank_name;
        $details->beneficiary_name = $request->beneficiary_name;
        $details->account_no = $request->account_no;
       $details->branch = $request->branch;
        $details->bank_code = $request->bank_code;
        $details->verified_status = 'UNVERIFIED';

        $details->save();

        return response()->json(['status' => 'success', 'message' => 'Bank updated successfully'],200);

    }



    // MoMo Wallet Related Code
    public function store_momo_wallet(Request $request){

        $validator = Validator::make($request->all(), [
            'momo_network' => 'required|string',
            'beneficiary_name' => 'required|string',
            'momo_no' => 'required|string|unique:momo__wallets',
            'network_code' => 'required|string' 
            
        ],
        [
            'momo_network.required' => 'Kindly choose a network',
            'beneficiary_name.required' => 'Kindly enter name on the wallet',
            'network_code.required' => 'Kindly set network code',
            'momo_no.required' => 'Kindly enter the wallet number',
            'momo_no.unique' => 'Wallet number already exist'
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }

        $details = new Momo_Wallet();

        $details->momo_network = $request->momo_network;
        $details->beneficiary_name = $request->beneficiary_name;
        $details->momo_no = $request->momo_no;
        $details->network_code = $request->network_code;
        $details->verified_status = 'UNVERIFIED';
        $details->user_id = Auth()->user()->id;

        $details->save();

        return response()->json(['status' => 'success','message' => 'MoMo added successfully'],200);
        
    }



    public function update_momo_wallet(Request $request){

        $validator = Validator::make($request->all(), [
            'momo_network' => 'required|string',
            'beneficiary_name' => 'required|string',
            'momo_no' => 'required|string',
            'network_code' => 'required|string' 
            
        ],
        [
            'momo_network.required' => 'Kindly choose a network',
            'beneficiary_name.required' => 'Kindly enter name on the wallet',
            'network_code.required' => 'Kindly set network code',
            'momo_no.required' => 'Kindly enter the wallet number'
        ]
        );

        if($validator->fails()){
            return response()->json(  ['status' => 'error',
                'message' => $validator->errors()], 400);
        }
        
       $details = Momo_Wallet::find($request->momo_wallet_id);

        $details->momo_network = $request->momo_network;
        $details->beneficiary_name = $request->beneficiary_name;
        $details->momo_no = $request->momo_no;
        $details->network_code = $request->network_code;
        $details->verified_status = 'UNVERIFIED';
        $details->user_id = Auth()->user()->id;

        $details->save();

        return response()->json(['status' => 'success', 'message' => 'MoMo updated successfully'],200);

    }



    public function approve_kyc($user_id){

        Identification::where('user_id',$user_id)->first()->update([
        'verified_status' => 'VERIFIED'
       ]);


        Bank_Wallet::where('user_id',$user_id)->first()->update([
            'verified_status' => 'VERIFIED'
           ]);


        Momo_Wallet::where('user_id',$user_id)->first()->update([
            'verified_status' => 'VERIFIED'
           ]);


           return response()->json(['status' => 'success', 'message' => 'KYC Approved'],200);

    }


    public function deleter_identity($identity_id){
        $del = Identification::find($identity_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }

    public function deleter_user($user_id){
        $del = User::find($user_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }

    public function deleter_biz_profile($biz_id){
        $del = Business_Profile::find($biz_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function deleter_contact_details($cont_id){
        $del = Contact_Details::find($cont_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function deleter_momo($momo_id){
        $del = Momo_Wallet::find($momo_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function deleter_bank($bank_id){
        $del = Bank_Wallet::find($bank_id)->delete();

        return response()->json(['status' => 'success', 'message' => 'Details deleted successfully'],200);
    }


    public function test_query(Request $request){
        $d = $request->query('reference');

        return response()->json(['status' => 'success', 'message' => $d],200);

    }

}
