<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use HasFactory;

    protected $table = 'events';

    public function user(){
        return $this->belongsTo('App\Models\User','user_id', 'id');
    }

    public function event_ticket(){
        return $this->hasMany('App\Models\EventTicket', 'event_id','id');
    }

    public function event_payment(){
        return $this->hasMany('App\Models\EventPayment', 'event_id','id');
    }

    public function client_ticket(){
        return $this->hasMany('App\Models\ClientEventTicket', 'event_id','id');
    }

} 
