<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transport extends Model
{
    use HasFactory;

    protected $table = 'transports';

    public function user(){
        return $this->belongsTo('App\Models\User','user_id', 'id');
    }
    public function transport_ticket(){
        return $this->hasMany('App\Models\TransportTicket', 'transport_id', 'id');
    }

    public function transport_payment_rel(){
        return $this->hasMany('App\Models\TransportPayment', 'transport_id', 'id');
    }

    public function transport_route(){
        return $this->hasMany('App\Models\TransportRoute', 'transport_id', 'id');

    } 
}
