<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransportRoute extends Model
{
    use HasFactory;

    protected $table = 'transport_routes';
    
    public function transport(){
        return $this->belongsTo('App\Models\Transport', 'transport_id', 'id');
    }

    public function transport_dpearture_date(){
        return $this->hasMany('App\Models\TransportDepartureDate', 'transport_route_id', 'id');
    }

    public function transport_vehicle(){
        return $this->hasMany('App\Models\TransportVehicle', 'transport_route_id', 'id');
    }

    public function transport_pickuppoint(){
        return $this->hasMany('App\Models\TransportPickuppoints', 'transport_route_id', 'id');
    }

    public function transport_ticket(){
        return $this->hasMany('App\Models\TransportTicket', 'transport_route_id', 'id');
    }

    public function client_transport_ticket(){
        return $this->hasMany('App\Models\ClientTransportTicket', 'transport_route_id', 'id');
    }

    public function transport_payment(){
        return $this->hasMany('App\Models\TransportPayment', 'transport_route_id', 'id');
    }
}
