<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Notifications\EmailVerificationNotification;
use App\Notifications\ResetPasswordNotification;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject, MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'mobile',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

         // Method to send email verification
    public function sendEmailVerificationNotification()
    {
        // We override the default notification and will use our own
        $this->notify(new EmailVerificationNotification());
    }

    public function sendPasswordResetNotification($token)
    {
        $url = 'http://127.0.0.1:8000/api/reset-password?token='.$token;

        $this->notify(new ResetPasswordNotification($url));
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }


    public function contact_details(){
        return $this->hasOne('App\Models\Contact_Details','user_id', 'id');
    }

 
    public function events(){
        return $this->hasMany('App\Models\Event','user_id', 'id');
    }

    public function transport(){
        return $this->hasMany('App\Models\Transport', 'user_id','id');
    }

    public function EventPayment(){
        return $this->hasMany('App\Models\EventPayment', 'user_id','id');
    }

    public function TransportPayment(){
        return $this->hasMany('App\Models\TransportPayment', 'user_id', 'id');
    }

    public function Withdrawal(){
        return $this->hasMany('App\Models\Withdrawal', 'user_id', 'id');
    }
    
    public function business_profile(){
        return $this->hasOne('App\Models\Business_Profile', 'user_id', 'id');
    }

    public function bank_wallet(){
        return $this->hasOne('App\Models\Bank_Wallet', 'user_id', 'id');
    }

    /*
    * Momo Wallet, Identification, Phone_verfications
    */
    public function momo_wallet(){
        return $this->hasOne('App\Models\Momo_Wallet', 'user_id', 'id');
    }

    public function identification(){
        return $this->hasOne('App\Models\Identification', 'user_id', 'id');
    }

    public function phone_verication(){
        return $this->hasOne('App\Models\Phone_Verification', 'user_id', 'id');

    } 
}
