<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact__details', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique();
            $table->integer('phone')->unique();
            $table->string('digital_addr')->nullable();
            $table->string('addr_country')->default('Ghana');
            $table->string('addr_region');
            $table->string('addr_city');
            $table->string('addr_street');
            $table->string('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact__details');
    }
}
