<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBankWalletsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank__wallets', function (Blueprint $table) {
            $table->id();
            $table->string('bank_name');
            $table->string('beneficiary_name');
            $table->string('account_no')->unique();
            $table->string('branch')->nullable();
            $table->string('bank_code')->nullable();
            $table->integer('user_id');
            $table->string('verified_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank__wallets');
    }
}
