<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMomoWalletsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('momo__wallets', function (Blueprint $table) {
            $table->id();
            $table->string('momo_network');
            $table->string('beneficiary_name');
            $table->string('momo_no')->unique();
            $table->integer('user_id');
            $table->string('network_code')->nullable();
            $table->string('verified_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('momo__wallets');
    }
}
