<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientEventTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_event_tickets', function (Blueprint $table) {
            $table->id();
            $table-> string('ticket_title');
            $table-> integer('event_ticket_id');
            $table-> float('ticket_price');
            $table-> string('ticket_token');
            $table-> integer('event_id'); 
            $table-> string('client_name');
            $table-> string('client_email')->nullable();
            $table-> string('client_mobile')->nullable();
            $table-> string('transaction_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_event_tickets');
    }
}
