<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientTransportTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_transport_tickets', function (Blueprint $table) {
            $table->id();
            $table-> string('ticket_title');
            $table-> integer('transport_ticket_id');
            $table-> float('ticket_price');
            $table-> string('ticket_token');
            $table-> string('origin');
            $table-> string('destination');
            $table-> string('pickup_point');
            $table-> integer('transport_route_id');
            $table-> integer('seat_no');
            $table-> date('departure_date');
            $table-> dateTime('departure_time');
            $table-> string('type_of_vehicle');
            $table-> string('client_name');
            $table-> string('client_email')->nullable();
            $table-> string('client_mobile')->nullable();
            $table-> string('transaction_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_transport_tickets');
    }
}
