<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('event_id');
            $table-> string('ticket_title');
            $table-> integer('event_ticket_id');
            $table-> float('amount');
            $table-> string('amount_paid')->default(0.00);
            $table-> integer('qty');
            $table-> string('transaction_id');
            $table->string('payment_status')->default('PENDING');
            $table-> string('client_name');
            $table-> string('client_email');
            $table-> string('client_mobile'); 
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('event_payments');
    }
}
