<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransportPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transport_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table-> integer('transport_route_id');
            $table-> string('ticket_title');
            $table-> integer('transport_ticket_id');
            $table-> float('amount');
            $table-> string('amount_paid')->nullable();
            $table-> string('transaction_id');
            $table->string('payment_status')->nullable();
            $table-> string('client_name');
            $table-> string('client_email');
            $table-> string('client_mobile');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transport_payments');
    }
}
