<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



/*
|--------------------------------------------------------------------------
| User Authentication API Routes
|--------------------------------------------------------------------------
*/

Route::group(['middleware'=>['api']], function($router){
    Route::post('/register', [AuthController::class, 'register']);

    Route::post('/login', [AuthController::class, 'login']);

    Route::get('/welcome', [AuthController::class, 'index'])->middleware('verified');

    Route::post('/email/verification-notification', [AuthController::class, 'resendVerificationLink'])->middleware(['throttle:6,1'])->name('verification.send');

    Route::get('/verify-email/{id}/{hash}', [AuthController::class, 'verify'])->name('verification.verify');

    Route::post('/reset-link', [AuthController::class, 'sendPasswordResetLink']);

    Route::post('/reset-password', [AuthController::class, 'resetPassword']);

    Route::post('/logout', [AuthController::class, 'logout']);
});

/*
|--------------------------------------------------------------------------
| Authenticated User API Routes
|--------------------------------------------------------------------------
*/


Route::group(['middleware'=>['api'],'prefix' => 'user'], function($router){

    Route::post('/contact', [UserController::class, 'store_contact_details']);
    Route::post('/contact-update', [UserController::class, 'update_contact_details']);


    Route::post('/business', [UserController::class, 'store_business_profile']);
    Route::post('/business-update', [UserController::class, 'update_business_profile']);


    Route::post('/identity', [UserController::class, 'store_identification']);
    Route::post('/identity-update', [UserController::class, 'update_identification']);

    Route::post('/bank', [UserController::class, 'store_bank_wallet']);
    Route::post('/bank-update', [UserController::class, 'update_bank_wallet']);


    Route::post('/momo', [UserController::class, 'store_momo_wallet']);
    Route::post('/momo-update', [UserController::class, 'update_momo_wallet']);


    Route::get('/', [UserController::class, 'user_index']);

    Route::get('/business-delete/{biz_id}', [UserController::class, 'deleter_biz_profile']); 

    Route::get('/delete/{user_id}', [UserController::class, 'deleter_user']);

    Route::get('/identity-delete/{identity_id}', [UserController::class, 'deleter_identity']);

    Route::get('/contact-delete/{cont_id}', [UserController::class, 'deleter_contact_details']);

    Route::get('/momo-delete/{momo_id}', [UserController::class, 'deleter_momo']);

    Route::get('/bank-delete/{bank_id}', [UserController::class, 'deleter_bank']);
    
});


Route::get('/fetch-banks', [UserController::class, 'fetch_banks']);

Route::get('/fetch-momo', [UserController::class, 'fetch_momo_wallets']);

Route::post('/kyc', [UserController::class, 'do_kyc']);


Route::get('/approve-kyc/{user_id}', [UserController::class, 'approve_kyc']);

Route::get('/query', [UserController::class, 'test_query']);







/* | Event API Routes | */

Route::group(['middleware' =>['api'], 'prefix' => 'event'], function($router){

    Route::get('/single/{event_id}', [EventController::class, 'single_event']);

    Route::get('/all', [EventController::class, 'all_events']);

    Route::post('/store', [EventController::class, 'store_event']);
    Route::post('/update', [EventController::class, 'update_event']);


    Route::post('/ticket-store', [EventController::class, 'store_event_ticket']);
    Route::post('/ticket-update', [EventController::class, 'update_event_ticket']);


    Route::post('/client-ticket-store', [EventController::class, 'store_client_event_ticket']);
    Route::post('/client-ticket-update', [EventController::class, 'update_client_event_ticket']);
    Route::post('/client-ticket-update-trx', [EventController::class, 'update_client_event_ticket_only_trx_id']);


    Route::post('/payment-store', [EventController::class, 'store_event_payment']);
    Route::get('/payment-update', [EventController::class, 'update_event_payment']);


    Route::get('/delete/{event_id}', [EventController::class, 'delete_event']);
    Route::get('/ticket-delete/{event_ticket_id}', [EventController::class, 'delete_event_ticket']);
    Route::get('/client-ticket-delete/{client_ticket_id}', [EventController::class, 'delete_client_ticket']);
    Route::get('/payment-delete/{event_payment_id}', [EventController::class, 'delete_event_payment']);

    
});










/* | Transport API Routes | */








/*
|--------------------------------------------------------------------------
| Guest User API Routes
|--------------------------------------------------------------------------
*/
